
clear all;
%clc;

restoredefaultpath;
addpath c:/dynare/6.4/matlab

constraint_vars = {'NOCON','NNCON'};
policy_vars = {'SOCIAL_PLANNER','RAMSEY'};

cnt = 1;
for ip = 1:numel(policy_vars)    
    for ic = 1:numel(constraint_vars)
        if strcmp(constraint_vars{1,ic},'NOCON') && strcmp(policy_vars{1,ip},'SOCIAL_PLANNER')
            dynare SP_vs_ramsey -DSOCIAL_PLANNER;% nowarn ;
        elseif strcmp(constraint_vars{1,ic},'NNCON') && strcmp(policy_vars{1,ip},'SOCIAL_PLANNER')
            dynare SP_vs_ramsey -DNNCON -DSOCIAL_PLANNER;
        elseif strcmp(constraint_vars{1,ic},'NOCON') && strcmp(policy_vars{1,ip},'RAMSEY')
            dynare SP_vs_ramsey -DRAMSEY;
        elseif strcmp(constraint_vars{1,ic},'NNCON') && strcmp(policy_vars{1,ip},'RAMSEY')
            dynare SP_vs_ramsey -DNNCON -DRAMSEY;
        else
            error('No valid variant chosen')
        end
        
        srcfile = 'SP_vs_ramsey/Output/SP_vs_ramsey_results.mat';
        dstfile = ['SP_vs_ramsey/',policy_vars{1,ip},'_',constraint_vars{1,ic},'.mat'];
        movefile(srcfile,dstfile);
        
        
        cnt = cnt + 1;
    end        
end
clear cnt;


