clear all;

constraint_vars = {'NOCON','NNCON'};
policy_vars = {'SOCIAL_PLANNER','RAMSEY'};

styles = {'-','-.','--',':'};
TT = 50;
figure;
cnt = 1;
for ip = 1:numel(policy_vars)    
    for ic = 1:numel(constraint_vars)
        
        tmp_name = [policy_vars{1,ip},'-',constraint_vars{1,ic}];
        NAMES{1,cnt} = regexprep(replace(lower(tmp_name), "_", " "), '(^|\s)\w', '${upper($0)}');
        
        load(['SP_vs_ramsey/',policy_vars{1,ip},'_',constraint_vars{1,ic}],'M_','oo_');
    
        MO{1,cnt} = moo2struct(M_, oo_);
    
        if strcmp(policy_vars{1,ip},'SOCIAL_PLANNER')
            MO{1,cnt}.sim.tau = MO{1,cnt}.sim.MUX./MO{1,cnt}.sim.varrho;
        end
        plot(MO{1,cnt}.sim.tau(1:TT),styles{1,cnt},'LineWidth',2);
        hold all;
         
        cnt = cnt+1;
    end
end
xlabel('Period')
ylabel('\tau')
legend(NAMES)