function modeloutput = moo2struct(M,oo)
% moo2struct: convert Dynare objects to a struct
%
% INPUTS:
%   M: Dynare model object M_
%   oo: Dynare output object oo_
%
% OUTPUTS:
%   modeloutput: struct with model variables and parameters
%
% Example:
%   modeloutput = moo2struct(M_,oo_);

% Get the model variables and parameters
modeloutput = struct();
modeloutput.par = struct();

% Add parameters to the output struct
for i = 1:length(M.params)
    param_name = strtrim(M.param_names{i});
    modeloutput.par.(param_name) = M.params(i);
end

modeloutput.ss = struct();
if ~isempty(oo.endo_simul)
    modeloutput.sim = struct();
end

% Add endo. variables to the output struct
for i = 1:length(M.endo_names)
    var_name = strtrim(M.endo_names{i});
    modeloutput.ss.(var_name) = oo.steady_state(i);
    if isfield(modeloutput, 'sim')
        modeloutput.sim.(var_name) = oo.endo_simul(i,:);
    end
end

% Add exo. variables
for i = 1:length(M.exo_names)
    exo_name = strtrim(M.exo_names{i});

    if isfield(modeloutput, 'sim')
        modeloutput.sim.(exo_name) = oo.exo_simul(:,i)';
    end
end

end

